#!/usr/local/bin/perl

%coin2ix = (qw/p 0 g 2 s 3 c 4/);
%soldamt = ();
%soldqty = ();

$soldre = '\[
     [A-z][a-z][a-z]          # Day abbreviation
     \s
     [A-z][a-z][a-z]          # Month abbreviation
     \s
     \d\d               # Day number
     \s
     \d\d:\d\d:\d\d          # Time
     \s
     \d\d\d\d          # Year
     \]
     \s
     (.*)               # Buyer
     \spurchased\s
     (\d+)               # Quantity
     \s
     (.*)               # Item
     \sfor\s\(\s
     (.*)               # Price
     \)\.';

($Second, $Minute, $Hour, $Day, $Month, $Year, $WeekDay, $DayOfYear, $IsDST) = localtime(time);
$Month += 1;
$Year += 1900;
$Day = "0" . $Day if ($Day < 10);
$Month = "0" . $Month if ($Month < 10);
$Hour = "0" . $Hour if ($Hour < 10);
$Minute = "0" . $Minute if ($Minute < 10);

$logfile = ">Everquest$Year-$Month-$Day\@$Hour$Minute.xls";
open(xlout, $logfile) or die ("Could not open file. $!");

# go through all lines, calculate statistics based on individual items
while (<>) {
     chomp;
     if ($_ =~ /$soldre/x) {
          $buyer = $1;
          $qty = $2;
          $itemname = $3;
          $price = $4;
          $amt = long_price_2_short_price($price);
        
          printf xlout ("%s\t%s\t%5d\t%10.3f\n",
                         $buyer, $itemname, $qty, $amt);

     }
}

sub long_price_2_short_price {
     my $name;
     my $value;
     my $price = shift;
     my @fields = split(' ', $price);
     my $count = scalar @fields;
     if ($count < 1 or $count > 4) {
          print STDERR "Something is wrong with the price field: $price\n";
          exit(-1);
     }
     @cointab = (0, ".", 0, 0, 0);
     foreach (@fields) {
          ($value, $name) = /(\d+)([pgsc])/;
          $cointab[$coin2ix{$name}] = $value;
     }
     return join('', @cointab);
} 
