@rem = '
@echo off
if exist %0.bat goto NOEXT
perl %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
goto END_BATCH_FILE
:NOEXT
perl %0.bat %1 %2 %3 %4 %5 %6 %7 %8 %9
goto END_BATCH_FILE
@rem ';

#!/usr/local/bin/perl

%coin2ix = (qw/p 0 g 2 s 3 c 4/);
%soldamt = ();
%soldqty = ();

$soldre = '\[
	[A-Z][a-z][a-z]		# Day abbreviation
	\s
	[A-Z][a-z][a-z]		# Month abbreviation
	\s
	\d\d			# Day number
	\s
	\d\d:\d\d:\d\d		# Time
	\s
	\d\d\d\d		# Year
	\]
	\s
	(.*)			# Buyer
	\spurchased\s
	(\d+)			# Quantity
	\s
	(.*)			# Item
	\sfor\s\(\s
	(.*)			# Price
	\)\.';

while (<>) {
	chomp;
	if ($_ =~ /$soldre/x) {
		$buyer = $1;
		$qty = $2;
		$itemname = $3;
		$price = $4;
		$amt = long_price_2_short_price($price);
		$soldkey = join("\t", $buyer, $itemname);
		$soldqty{$soldkey} += $qty;
		$soldamt{$soldkey} += $amt;
	}
}

$totalamt  = 0; 
$totalqty  = 0;
$itemamt   = 0; 
$itemqty   = 0;
$fencepost = 0;
$currbuyer  = "";
foreach $soldkey (sort {$a cmp $b} keys %soldqty) {
	($buyer, $itemname) = split("\t", $soldkey);
	if ($buyer ne $currbuyer) {
		if ($fencepost) {
			print STDOUT "\t-----  ----------\n";
			printf STDOUT ("\t%5d  %10.3f\n", $itemqty, $itemamt);
			$totalqty += $itemqty;
			$totalamt += $itemamt;
			$itemqty = 0;
			$itemamt = 0;
			$fencepost = 0;
			print STDOUT "\n";
		}
		print STDOUT ($buyer, "\n\n");
		print STDOUT "\t Qty     Amount    Item\n";
		print STDOUT "\t-----  ----------  ------------------------\n";
		$currbuyer = $buyer;
	}
	$fencepost = 1;
	printf STDOUT ("\t%5d  %10.3f  %s\n",
	$soldqty{$soldkey}, $soldamt{$soldkey}, $itemname);
	$itemqty += $soldqty{$soldkey};
	$itemamt += $soldamt{$soldkey};
}

# Print total for last item.
print STDOUT "\t-----  ----------\n";
printf STDOUT ("\t%5d  %10.3f\n", $itemqty, $itemamt);
$totalqty += $itemqty;
$totalamt += $itemamt;

# Print total for all items.
print STDOUT "\nGrand Total\n\n";
print STDOUT "\t Qty     Amount    \n";
print STDOUT "\t-----  ----------\n";
printf STDOUT ("\t%5d  %10.3f\n", $totalqty, $totalamt);

sub long_price_2_short_price {
	my $name;
	my $value;
	my $price = shift;
	my @fields = split(' ', $price);
	my $count = scalar @fields;
	if ($count < 1 or $count > 4) {
		print STDERR "Something is wrong with the price field: $price\n";
		exit(-1);
	}
	@cointab = (0, ".", 0, 0, 0);
	foreach (@fields) {
		($value, $name) = /(\d+)([pgsc])/;
		$cointab[$coin2ix{$name}] = $value;
	}
	return join('', @cointab);
} 
        

EOT

__END__
:END_BATCH_FILE

pause


 
