@rem = '
@echo off
if exist %0.bat goto NOEXT
perl %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
goto END_BATCH_FILE
:NOEXT
perl %0.bat %1 %2 %3 %4 %5 %6 %7 %8 %9
goto END_BATCH_FILE
@rem ';


#!/usr/local/bin/perl

%coin2ix = (qw/p 0 g 2 s 3 c 4/);
%soldamt = ();
%soldqty = ();

$soldre = '\[
     [A-z][a-z][a-z]          # Day abbreviation
     \s
     [A-z][a-z][a-z]          # Month abbreviation
     \s
     \d\d               # Day number
     \s
     \d\d:\d\d:\d\d          # Time
     \s
     \d\d\d\d          # Year
     \]
     \s
     (.*)               # Buyer
     \spurchased\s
     (\d+)               # Quantity
     \s
     (.*)               # Item
     \sfor\s\(\s
     (.*)               # Price
     \)\.';

# go through all lines, calculate statistics based on individual items
while (<>) {
     chomp;
     if ($_ =~ /$soldre/x) {
          $buyer = $1;
          $qty = $2;
          $itemname = $3;
          $price = $4;
          $amt = long_price_2_short_price($price);
          $soldqty{$itemname} += $qty;
          $soldamt{$itemname} += $amt;
          if($amt > $soldmax{$itemname})
          {
                $soldmax{$itemname} = $amt;      
          }
          if($amt < $soldmin{$itemname} or $soldmin{$itemname} == 0)
          {
                $soldmin{$itemname} = $amt;      
          }
     }
}

$totalamt  = 0;
$totalqty  = 0;
system(cls);
printf STDOUT "Item Name                    Times Sold | High Price | Low Price | Total Price\n";
printf STDOUT "------------------------------------------------------------------------------\n";

# print each item, keep running grand total
foreach $itemname (sort {$a cmp $b} keys %soldqty) {

     # Print current item
     printf STDOUT ("%30s    %5d        %5d        %5d   %10.3f\n",
     $itemname,  $soldqty{$itemname}, $soldmax{$itemname}, $soldmin{$itemname}, $soldamt{$itemname});

     # add this item to grand total
     $totalqty += $soldqty{$itemname};
     $totalamt += $soldamt{$itemname};
}

# Print total for last item.
printf STDOUT ("\nTotal Items:%5d     Total Price:%10.3f\n", $totalqty, $totalamt);

sub long_price_2_short_price {
     my $name;
     my $value;
     my $price = shift;
     my @fields = split(' ', $price);
     my $count = scalar @fields;
     if ($count < 1 or $count > 4) {
          print STDERR "Something is wrong with the price field: $price\n";
          exit(-1);
     }
     @cointab = (0, ".", 0, 0, 0);
     foreach (@fields) {
          ($value, $name) = /(\d+)([pgsc])/;
          $cointab[$coin2ix{$name}] = $value;
     }
     return join('', @cointab);
} 

EOT

__END__
:END_BATCH_FILE
pause
