<?php
/* PHP EverQuest Spell Research Helper
   By:  Xorillian L`Amante for Xorithra L`Amante
   Notes:  This script was written using a MySQL 4.0 Database and has only
           been tested on that database.  Some things would be a lot easier
           if MySQL 4.1 were used, but I wanted to keep this code on stable
           versions only.  MySQL 4.0 does not, however, support subqueries so
           if it looks like I did things in a strange way, that's probably why.

           The original recipies were taken from Xorithra's Spell Research spreadsheet.
           You can update your database as you see fit and add any recipies you would 
           like.  Referential integrity on the tables is not maintained however, so be 
           careful what you add and remove. 
           
           Feel free to change any of the script that you would like to change, chances
           are I will not have the time to maintain this.  Feel free to give me a little
           credit though ;-)  */

//Options:
//-------------------------------------------------------------------
$originalsite = 'http://my.site.com/directoryOfscript/';           //  Location of the php script on your site, be sure to include trailing slash if your site automatically reads the index.php file (otherwise it should look like 'http://my.site.com/index.php')
$host = 'localhost';                                               //  Your database server (localhost unless you run your webserver separate)
$database = 'eqresearch';                                          //  The database you created for the component parser
$user = 'username';                                                //  Username that has access -- DO NOT USE ROOT
$pass = 'password';                                                //  Password for that username
$tablename = 'temptable';                                          //  Name of the temporary table for inventory
$header = 'header.html';                                           //  Full path and name of the file to use as a header
$footer = 'footer.html';                                           //  Full path and name of the file to use as a footer
$uploadsuccessful='Upload Successful!';                            //  Upload successful message
$uploadfailed='Invalid File or Upload Failed';                     //  Invalid File or Upload failed message
$notatextfile='Not a valid text file!';                            //  File is not a valid text file
$numberoffiles=8;                                                  //  Number of files to allow uploading of
$graphicheight=20;                                                 //  Height of component graphic in pixels
$graphicwidth=20;                                                  //  Width of component graphic in pixels
//-------------------------------------------------------------------
include('header.html');

if(isset($_POST['sendbutton']))
{
	//Connect to the database
	//--------------------------------------------------------------------------
	mysql_connect("$host", "$user", "$pass") or die("Could Not Connect");     //
	mysql_select_db("$database") or die(mysql_error());                       //
	//--------------------------------------------------------------------------

	// Create a temporary table to work with.  Temporary tables are only available to the current
	// connection and are dropped after the connection is closed.  Multiple tables of the same name
	// can be created at the same time for different connections, this prevents two users from
	// using the same table during their connection.
	doquery("CREATE TEMPORARY TABLE $tablename (EQID int(11) NOT NULL, PRIMARY KEY (EQID), ItemName varchar(255) NOT NULL, Quantity int(11) NOT NULL, IsComponent TinyInt(1) NOT NULL)");

	$afilehasbeenproccessed=0;
    // Process files 1 through numberoffiles
    for($i=0; $i<$numberoffiles; $i++)
    {
	    // If the file has a name, it means something was entered into that box, so process that information
	    if($_FILES['userfile']['name'][$i])
	    {
		    $filenum=$i+1;
		    // If the file is a plain text file then we can proceed.
		    if($_FILES['userfile']['type'][$i]=='text/plain')
		    {
			    // If we can open the file, then the upload was successful, add the information in it to the database 
			    // and set the processed variable to 1.
			    if($FILE=fopen($_FILES['userfile']['tmp_name'][$i], 'r'))
			    {
				    $fileinformation=$fileinformation.'<tr><td>File '.$filenum.':</td><td>'.$_FILES['userfile']['name'][$i].'</td><td class="fileuploadsuccessful">'.$uploadsuccessful.'</td></tr>'.chr(13);
				    addtodb($FILE,$tablename);
				    $afilehasbeenproccessed=1;
			    }
			    // Otherwise the upload failed.
			    else
			    {
				    $fileinformation=$fileinformation.'<tr><td>File '.$filenum.':</td><td>'.$_FILES['userfile']['name'][$i].'</td><td class="invalidfilewarning">'.$uploadfailed.'</td></tr>'.chr(13);
			    }
			    fclose($FILE);
		    }
		    // If the file is not plain text then display the filetype.  If the filetype is not known, display unknown.
		    else
		    {
			    $filetype=$_FILES['userfile']['type'][$i];
			    if(!$filetype)
			    {
				    $filetype='unknown';
			    }
			    $fileinformation=$fileinformation.'<tr><td>File '.$filenum.':</td><td>'.$_FILES['userfile']['name'][$i].'</td><td class="invalidfilewarning">'.$notatextfile.'</td><td>Type:</td><td>'.$filetype.'</tr>'.chr(13);
		    }
	    }
    }

	// Display File successes and failures:
	echo '<table class="fileinformation" border="0" summary="This is the file information.">'.chr(13);
	echo $fileinformation;
	echo '</table>'.chr(13);
	// If you would rather see file success and failures at the bottom of the page, comment this and uncomment the area stated below.

	// If a file was found to be valid, then move on to the next section
	if($afilehasbeenproccessed==1)
	{
		// Now that the character file is in the database, we get a list of all the components that we have.
		$result=doquery("SELECT $tablename.EQID, $tablename.Quantity FROM $tablename, components WHERE $tablename.EQID=components.EQID");
		$componentarray[]=Null;
		$ourcomponents=Null;
		$firstround=1;
		while($row=mysql_fetch_array($result, MYSQL_ASSOC))
		{
			if($firstround==1)
			{
				$ourcomponents=$row['EQID'];
				$componentarray[$row['EQID']]=$row['Quantity'];
				$firstround=0;
			}
			else
			{
				$ourcomponents=$ourcomponents.', '.$row['EQID'];
				$componentarray[$row['EQID']]=$row['Quantity'];
			}
		}
		// Append a 0 to the list of components because...well, I forget why I had to do that.  But it has something to do with
		// subqueries not working and the way the lookup on null based components is set up.  Oh, yeah, it's because instead of
		// using a subquery, you have to use AND and if AND returns a Null value then it is false.  But some spells don't have
		// 4 components and thus component 4, if not 3 will be null.  So, this says that if a recipe requires a null component,
		// we have that component.
		$ourcomponents=$ourcomponents.', 0';
		
		// Now that we have our list of components, we have to find out what spells we can make.  While we're at it
		// let's just get all the information we can on those spells.
		$result=doquery("SELECT spells.name AS SpellName, spells.LucyID, spells.beastlord, spells.cleric, spells.druid, spells.enchanter, spells.magician, spells.necromancer, spells.paladin, spells.ranger, spells.shadowknight, spells.shaman, spells.wizard, comp1.name AS Comp1Name, comp1.eqid AS Comp1ID, comp1.graphic AS Comp1graphic, comp2.name AS Comp2Name, comp2.eqid AS Comp2ID, comp2.graphic AS Comp2graphic, comp3.name AS Comp3Name, comp3.eqid AS Comp3ID, comp3.graphic AS Comp3graphic, comp4.name AS Comp4Name, comp4.eqid AS Comp4ID, comp4.graphic AS Comp4graphic FROM recipes, components AS comp1, components AS comp2, components AS comp3, components AS comp4 LEFT JOIN spells ON recipes.spellid=spells.lucyid WHERE comp1.eqid=recipes.component1 AND comp2.eqid=IFNULL(recipes.component2,0) AND comp3.eqid=IFNULL(recipes.component3,0) AND comp4.eqid=IFNULL(recipes.component4,0) AND comp1.eqid IN ($ourcomponents) AND comp2.eqid IN ($ourcomponents) AND comp3.eqid IN ($ourcomponents) AND comp4.eqid IN ($ourcomponents) ORDER BY spells.name");

		// Initialize all of our variables.
		$beastlord=Null;
		$beastlordI=0;
		$cleric=Null;
		$clericI=0;
		$druid=Null;
		$druidI=0;
		$enchanter=Null;
		$enchanterI=0;
		$magician=Null;
		$magicianI=0;
		$necromancer=Null;
		$necromancerI=0;
		$paladin=Null;
		$paladinI=0;
		$ranger=Null;
		$rangerI=0;
		$shadowknight=Null;
		$shadowknightI=0;
		$shaman=Null;
		$shamanI=0;
		$wizard=Null;
		$wizardI=0;

		// Create our tables
		while($row=mysql_fetch_array($result, MYSQL_ASSOC))
		{
			if($row['Comp1Name']=='NULL')
			{
				$row['Comp1Name']='&nbsp;';
			}
			else
			{
				$row['Comp1Name']='<a href="'.$originalsite.'?component='.$row['Comp1ID'].'&amp;compqty='.$componentarray[$row['Comp1ID']].'">'.$row['Comp1Name'].'</a> ('.$componentarray[$row['Comp1ID']].')';
			}
			if($row['Comp2Name']=='NULL')
			{
				$row['Comp2Name']='&nbsp;';
			}
			else
			{
				$row['Comp2Name']='<a href="'.$originalsite.'?component='.$row['Comp2ID'].'&amp;compqty='.$componentarray[$row['Comp2ID']].'">'.$row['Comp2Name'].'</a> ('.$componentarray[$row['Comp2ID']].')';
			}
			if($row['Comp3Name']=='NULL')
			{
				$row['Comp3Name']='&nbsp;';
			}
			else
			{
				$row['Comp3Name']='<a href="'.$originalsite.'?component='.$row['Comp3ID'].'&amp;compqty='.$componentarray[$row['Comp3ID']].'">'.$row['Comp3Name'].'</a> ('.$componentarray[$row['Comp3ID']].')';
			}
			if($row['Comp4Name']=='NULL')
			{
				$row['Comp4Name']='&nbsp;';
			}				
			else
			{
				$row['Comp4Name']='<a href="'.$originalsite.'?component='.$row['Comp4ID'].'&amp;compqty='.$componentarray[$row['Comp4ID']].'">'.$row['Comp4Name'].'</a> ('.$componentarray[$row['Comp4ID']].')';
			}
			if($row['Comp1graphic']=='NULL')
			{
				$row['Comp1graphic']=Null;
			}
			else
			{
				$row['Comp1graphic']='<img class="componentgraphic" src="images/'.$row['Comp1graphic'].'" alt="Component1 Graphic" width="'.$graphicwidth.'" height="'.$graphicheight.'" />';
			}
			if($row['Comp2graphic']=='NULL')
			{
				$row['Comp2graphic']=Null;
			}
			else
			{
				$row['Comp2graphic']='<img class="componentgraphic" src="images/'.$row['Comp2graphic'].'" alt="Component2 Graphic" width="'.$graphicwidth.'" height="'.$graphicheight.'" />';
			}				
			if($row['Comp3graphic']=='NULL')
			{
				$row['Comp3graphic']=Null;
			}
			else
			{
				$row['Comp3graphic']='<img class="componentgraphic" src="images/'.$row['Comp3graphic'].'" alt="Component3 Graphic" width="'.$graphicwidth.'" height="'.$graphicheight.'" />';
			}				
			if($row['Comp4graphic']=='NULL')
			{
				$row['Comp4graphic']=Null;
			}
			else
			{
				$row['Comp4graphic']='<img class="componentgraphic" src="images/'.$row['Comp4graphic'].'" alt="Component4 Graphic" width="'.$graphicwidth.'" height="'.$graphicheight.'" />';
			}
			
			if($row['beastlord']>0)
			{			
				$trclass = (($beastlordI % 2)==0) ? ('class1') : ('class2');
				$beastlordI++;
				$beastlord=$beastlord.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['beastlord'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
			}
			if($row['cleric']>0)
			{			
				$trclass = (($clericI % 2)==0) ? ('class1') : ('class2');
				$clericI++;
				$cleric=$cleric.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['cleric'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
			}
			if($row['druid']>0)
			{			
				$trclass = (($druidI % 2)==0) ? ('class1') : ('class2');
				$druidI++;
				$druid=$druid.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['druid'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
			}
			if($row['enchanter']>0)
			{			
				$trclass = (($enchanterI % 2)==0) ? ('class1') : ('class2');
				$enchanterI++;
				$enchanter=$enchanter.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['enchanter'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
			}
			if($row['magician']>0)
			{			
				$trclass = (($magicianI % 2)==0) ? ('class1') : ('class2');
				$magicianI++;
				$magician=$magician.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['magician'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
			}
			if($row['necromancer']>0)
			{			
				$trclass = (($necromancerI % 2)==0) ? ('class1') : ('class2');
				$necromancerI++;
				$necromancer=$necromancer.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['necromancer'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
			}
			if($row['paladin']>0)
			{			
				$trclass = (($paladinI % 2)==0) ? ('class1') : ('class2');
				$paladinI++;
				$paladin=$paladin.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['paladin'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
			}
			if($row['ranger']>0)
			{			
				$trclass = (($rangerI % 2)==0) ? ('class1') : ('class2');
				$rangerI++;
				$ranger=$ranger.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['ranger'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
			}
			if($row['shadowknight']>0)
			{			
				$trclass = (($shadowknightI % 2)==0) ? ('class1') : ('class2');
				$shadowknightI++;
				$shadowknight=$shadowknight.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['shadowknight'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
			}
			if($row['shaman']>0)
			{			
				$trclass = (($shamanI % 2)==0) ? ('class1') : ('class2');
				$shamanI++;
				$shaman=$shaman.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['shaman'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
			}
			if($row['wizard']>0)
			{			
				$trclass = (($wizardI % 2)==0) ? ('class1') : ('class2');
				$wizardI++;
				$wizard=$wizard.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['wizard'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
			}
		}
		echo '<table class="spells" border="1" summary="Spells that you have the components to make.">'.chr(13);
		echo '<caption><em>You have the components to make the following spells:</em></caption>'.chr(13);
		classtable($beastlord,'Beastlord');
		classtable($cleric,'Cleric');
		classtable($druid,'Druid');
		classtable($enchanter,'Enchanter');
		classtable($magician,'Magician');
		classtable($necromancer,'Necromancer');
		classtable($paladin,'Paladin');
		classtable($ranger,'Ranger');
		classtable($shadowknight,'Shadowknight');
		classtable($shaman,'Shaman');
		classtable($wizard,'Wizard');
		echo '</table>';			
	}
	
	// Uncomment this and comment the top if you would rather the file success/failure display at the bottom.
	//echo '<table class="fileinformation" border="0" summary="This is the file information.">'.chr(13);
	//echo $fileinformation;
	//echo '</table>'.chr(13);
}
elseif(isset($_POST['componentsearch'])) 
{
	;
}
elseif(isset($_POST['spellsearch'])) 
{
	;
}
else
{
	$component=$_GET['component'];
	if($component>0)
	{
		//Connect to the database
		//--------------------------------------------------------------------------
		mysql_connect("$host", "$user", "$pass") or die("Could Not Connect");     //
		mysql_select_db("$database") or die(mysql_error());                       //
		//--------------------------------------------------------------------------
		$result=mysql_fetch_array(doquery("SELECT name, graphic FROM components WHERE EQID=$component"), MYSQL_ASSOC);
		$componentname=$result['name'];
		$compqty=$_GET['compqty'];

		$result=doquery("SELECT spells.name AS SpellName, spells.LucyID, spells.beastlord, spells.cleric, spells.druid, spells.enchanter, spells.magician, spells.necromancer, spells.paladin, spells.ranger, spells.shadowknight, spells.shaman, spells.wizard, comp1.name AS Comp1Name, comp1.eqid AS Comp1ID, comp1.graphic AS Comp1graphic, comp2.name AS Comp2Name, comp2.eqid AS Comp2ID, comp2.graphic AS Comp2graphic, comp3.name AS Comp3Name, comp3.eqid AS Comp3ID, comp3.graphic AS Comp3graphic, comp4.name AS Comp4Name, comp4.eqid AS Comp4ID, comp4.graphic AS Comp4graphic FROM recipes, components AS comp1, components AS comp2, components AS comp3, components AS comp4 LEFT JOIN spells ON recipes.spellid=spells.lucyid WHERE comp1.eqid=recipes.component1 AND comp2.eqid=IFNULL(recipes.component2,0) AND comp3.eqid=IFNULL(recipes.component3,0) AND comp4.eqid=IFNULL(recipes.component4,0) AND (comp1.eqid=$component OR comp2.eqid=$component OR comp3.eqid=$component OR comp4.eqid=$component) ORDER BY spells.name");
		if($result)
		{
			// Initialize class variables
			$beastlord=Null;
			$beastlordI=0;
			$cleric=Null;
			$clericI=0;
			$druid=Null;
			$druidI=0;
			$enchanter=Null;
			$enchanterI=0;
			$magician=Null;
			$magicianI=0;
			$necromancer=Null;
			$necromancerI=0;
			$paladin=Null;
			$paladinI=0;
			$ranger=Null;
			$rangerI=0;
			$shadowknight=Null;
			$shadowknightI=0;
			$shaman=Null;
			$shamanI=0;
			$wizard=Null;
			$wizardI=0;
			while($row=mysql_fetch_array($result, MYSQL_ASSOC))
			{
				if($row['Comp1Name']=='NULL')
				{
					$row['Comp1Name']='&nbsp;';
				}
				else
				{
					$row['Comp1Name']='<a href="'.$originalsite.'?component='.$row['Comp1ID'].'">'.$row['Comp1Name'].'</a>';
				}
				if($row['Comp2Name']=='NULL')
				{
					$row['Comp2Name']='&nbsp;';
				}
				else
				{
					$row['Comp2Name']='<a href="'.$originalsite.'?component='.$row['Comp2ID'].'">'.$row['Comp2Name'].'</a>';
				}
				if($row['Comp3Name']=='NULL')
				{
					$row['Comp3Name']='&nbsp;';
				}
				else
				{
					$row['Comp3Name']='<a href="'.$originalsite.'?component='.$row['Comp3ID'].'">'.$row['Comp3Name'].'</a>';
				}
				if($row['Comp4Name']=='NULL')
				{
					$row['Comp4Name']='&nbsp;';
				}				
				else
				{
					$row['Comp4Name']='<a href="'.$originalsite.'?component='.$row['Comp4ID'].'">'.$row['Comp4Name'].'</a>';
				}
				if($row['Comp1graphic']=='NULL')
				{
					$row['Comp1graphic']=Null;
				}
				else
				{
					$row['Comp1graphic']='<img class="componentgraphic" src="images/'.$row['Comp1graphic'].'" alt="Component1 Graphic" width="'.$graphicwidth.'" height="'.$graphicheight.'" />';
				}
				if($row['Comp2graphic']=='NULL')
				{
					$row['Comp2graphic']=Null;
				}
				else
				{
					$row['Comp2graphic']='<img class="componentgraphic" src="images/'.$row['Comp2graphic'].'" alt="Component2 Graphic" width="'.$graphicwidth.'" height="'.$graphicheight.'" />';
				}				
				if($row['Comp3graphic']=='NULL')
				{
					$row['Comp3graphic']=Null;
				}
				else
				{
					$row['Comp3graphic']='<img class="componentgraphic" src="images/'.$row['Comp3graphic'].'" alt="Component3 Graphic" width="'.$graphicwidth.'" height="'.$graphicheight.'" />';
				}				
				if($row['Comp4graphic']=='NULL')
				{
					$row['Comp4graphic']=Null;
				}
				else
				{
					$row['Comp4graphic']='<img class="componentgraphic" src="images/'.$row['Comp4graphic'].'" alt="Component4 Graphic" width="'.$graphicwidth.'" height="'.$graphicheight.'" />';
				}
				
				if($row['beastlord']>0)
				{			
					$trclass = (($beastlordI % 2)==0) ? ('class1') : ('class2');
					$beastlordI++;
					$beastlord=$beastlord.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['beastlord'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
				}
				if($row['cleric']>0)
				{			
					$trclass = (($clericI % 2)==0) ? ('class1') : ('class2');
					$clericI++;
					$cleric=$cleric.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['cleric'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
				}
				if($row['druid']>0)
				{			
					$trclass = (($druidI % 2)==0) ? ('class1') : ('class2');
					$druidI++;
					$druid=$druid.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['druid'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
				}
				if($row['enchanter']>0)
				{			
					$trclass = (($enchanterI % 2)==0) ? ('class1') : ('class2');
					$enchanterI++;
					$enchanter=$enchanter.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['enchanter'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
				}
				if($row['magician']>0)
				{			
					$trclass = (($magicianI % 2)==0) ? ('class1') : ('class2');
					$magicianI++;
					$magician=$magician.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['magician'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
				}
				if($row['necromancer']>0)
				{			
					$trclass = (($necromancerI % 2)==0) ? ('class1') : ('class2');
					$necromancerI++;
					$necromancer=$necromancer.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['necromancer'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
				}
				if($row['paladin']>0)
				{			
					$trclass = (($paladinI % 2)==0) ? ('class1') : ('class2');
					$paladinI++;
					$paladin=$paladin.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['paladin'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
				}
				if($row['ranger']>0)
				{			
					$trclass = (($rangerI % 2)==0) ? ('class1') : ('class2');
					$rangerI++;
					$ranger=$ranger.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['ranger'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
				}
				if($row['shadowknight']>0)
				{			
					$trclass = (($shadowknightI % 2)==0) ? ('class1') : ('class2');
					$shadowknightI++;
					$shadowknight=$shadowknight.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['shadowknight'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
				}
				if($row['shaman']>0)
				{			
					$trclass = (($shamanI % 2)==0) ? ('class1') : ('class2');
					$shamanI++;
					$shaman=$shaman.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['shaman'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
				}
				if($row['wizard']>0)
				{			
					$trclass = (($wizardI % 2)==0) ? ('class1') : ('class2');
					$wizardI++;
					$wizard=$wizard.'<tr class="'.$trclass.'"><td><a href="http://lucy.allakhazam.com/spell.html?id='.$row['LucyID'].'">'.$row['SpellName'].'</a> ('.$row['wizard'].')</td><td>'.$row['Comp1graphic'].$row['Comp1Name'].'</td><td>'.$row['Comp2graphic'].$row['Comp2Name'].'</td><td>'.$row['Comp3graphic'].$row['Comp3Name'].'</td><td>'.$row['Comp4graphic'].$row['Comp4Name'].'</td></tr>'.chr(13);
				}
			}
			echo '<table class="spells" border="1" summary="Spells that this component is used in.">'.chr(13);
			if($compqty>0)
			{
				echo '<caption><em>You have '.$compqty.' '.$componentname.' available for use in the following spells:</em></caption>'.chr(13);
			}
			else
			{
				echo '<caption><em>'.$componentname.' is used in the following spells:</em></caption>'.chr(13);
			}
			classtable($beastlord,'Beastlord');
			classtable($cleric,'Cleric');
			classtable($druid,'Druid');
			classtable($enchanter,'Enchanter');
			classtable($magician,'Magician');
			classtable($necromancer,'Necromancer');
			classtable($paladin,'Paladin');
			classtable($ranger,'Ranger');
			classtable($shadowknight,'Shadowknight');
			classtable($shaman,'Shaman');
			classtable($wizard,'Wizard');
			echo '</table>';
		}
		else
		{
			echo '<p class="invalidcomponent">Invalid Component or Component is not in the Database</p>';
		}	
	}
	else
	{
		echo '<form action="'.$originalsite.'" method="post" enctype="multipart/form-data">'.chr(13);
		echo '<table class="uploadlist" border="0" summary="This is a list of files to upload.">'.chr(13);
		echo '<caption><em>Files to upload:</em></caption>'.chr(13);
		for($i=1; $i<=$numberoffiles; $i++)
		{
			echo '<tr><td>File '.$i.':</td><td><input type="hidden" name="MAX_FILE_SIZE" value="30000"/><input name="userfile[]" type="file" /><br /></td></tr>'.chr(13);
		}
		echo '</table>'.chr(13);
		echo '<p class="formbuttons"><input type="submit" name="sendbutton" value="Send Files" /><input type="reset" value="Reset Form" /></p>'.chr(13);
		echo '</form>'.chr(13);
	}
}

include($footer);

// This function runs a query and outputs any errors we have
function doquery($thisquery)
{
	$doqueryresult = mysql_query($thisquery);
	if (!$doqueryresult) 
	{
   		die('Query Failure: ' . mysql_error());
	}
	return $doqueryresult;
}

// This function updates the database.
function addtodb($thisfile,$thistable)
{
	// Parse until the end of the file.
	// The idea is to add everything to our database unless it's already there, in which case we update the quantity
	while($currentline=fgetcsv($thisfile, 1000, "\t"))
	{
		// Check to make sure this is a character file output from EverQuest
		if(trim($currentline[1])!='Name' && trim($currentline[1])!='Empty')
		{
			$location=mysql_escape_string(trim($currentline[0]));
			$name=mysql_escape_string(trim($currentline[1]));
			$id=mysql_escape_string(trim($currentline[2]));
			$quantity=mysql_escape_string(trim($currentline[3]));
			// Check to make sure the entry has an ID
			if($id)
			{
				$result=doquery("SELECT Quantity FROM $thistable WHERE $thistable.EQID=$id");
				$row=mysql_fetch_array($result, MYSQL_ASSOC);
				// If the query returns a value for quantity then we want to update that quantity instead
				// of adding a new entry to the table.
				if($row['Quantity'])
				{
					$quantity=$quantity+$row['Quantity'];
					doquery("UPDATE $thistable SET Quantity=$quantity WHERE $thistable.EQID=$id");
				}
				// Otherwise we add a new entry.
				else
				{
					// Check to see if we have values for name, id, and quantity.  If we do, add it to the table.
					if($name && $id && $quantity)
					{
						doquery("INSERT INTO $thistable (EQID, ItemName, Quantity, IsComponent) VALUES ($id, '$name', $quantity, 0)");
					}
				}
			}
		}
	}
}

function classtable($theserows,$thisclass)
{
	if($theserows)
	{
		echo '<tr><th class="spellname">'.$thisclass.' Spells</th><th class="comp1">Component 1</th><th class="comp2">Component 2</th><th class="comp3">Component 3</th><th class="comp4">Component 4</th></tr>'.chr(13);
		echo $theserows;
	}
}

?>