@rem = '
@echo off
if exist %0.bat goto NOEXT
perl %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
goto END_BATCH_FILE
:NOEXT
perl %0.bat %1 %2 %3 %4 %5 %6 %7 %8 %9
goto END_BATCH_FILE
@rem ';
#!/usr/local/bin/perl

%coin2ix = (qw/p 0 g 2 s 3 c 4/);

# Regular expression for selling items
$soldre = '\[
     [A-z][a-z][a-z]          # Day abbreviation
     \s
     ([A-z][a-z][a-z]          # Month abbreviation
     \s
     \d\d)               # Day number
     \s
     (\d\d:\d\d:\d\d)          # Time
     \s
     (\d\d\d\d)          # Year
     \]
     \s
     (.*)               # Buyer
     \spurchased\s
     (\d+)               # Quantity
     \s
     (.*)               # Item
     \sfor\s\(\s
     (.*)               # Price
     \)\.';

# Get current date/time and format
($Second, $Minute, $Hour, $Day, $Month, $Year, $WeekDay, $DayOfYear, $IsDST) = localtime(time);
$Month += 1;
$Year += 1900;
$Day = "0" . $Day if ($Day < 10);
$Month = "0" . $Month if ($Month < 10);
$Hour = "0" . $Hour if ($Hour < 10);
$Minute = "0" . $Minute if ($Minute < 10);

use FindBin qw($Bin);
$outdir = $Bin; 

$logfile = ">$outdir\\" . "Everquest$Year-$Month-$Day\@$Hour$Minute.xls";
open(xlout, $logfile) or die ("Could not open file. $!");

%soldamt = ();
%soldqty = ();
# go through all lines, parse and print any sales
while (<>) {
     chomp;
     if ($_ =~ /$soldre/x) {
          $monthday = $1;
          $selltime = $2;
          $year = $3;
          $buyer = $4;
          $qty = $5;
          $itemname = $6;
          $price = $7;
          $amt = long_price_2_short_price($price);
       
          printf xlout ("$buyer\t" . "$itemname\t" . "$qty\t" . "$amt\t" .
                        "$monthday, $year\t" . "$selltime\n");
     }
}

sub long_price_2_short_price {
     my $name;
     my $value;
     my $price = shift;
     my @fields = split(' ', $price);
     my $count = scalar @fields;
     if ($count < 1 or $count > 4) {
          print STDERR "Something is wrong with the price field: $price\n";
          exit(-1);
     }
     @cointab = (0, ".", 0, 0, 0);
     foreach (@fields) {
          ($value, $name) = /(\d+)([pgsc])/;
          $cointab[$coin2ix{$name}] = $value;
     }
     return join('', @cointab);
}

EOT

__END__
:END_BATCH_FILE