VERSION 5.00
Begin VB.Form SkillCalc 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Tradeskill Calculator"
   ClientHeight    =   2820
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   4740
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2820
   ScaleWidth      =   4740
   StartUpPosition =   3  'Windows Default
   Begin VB.OptionButton optValue 
      Height          =   255
      Index           =   3
      Left            =   4320
      TabIndex        =   7
      TabStop         =   0   'False
      Top             =   1260
      Width           =   255
   End
   Begin VB.OptionButton optValue 
      Height          =   255
      Index           =   2
      Left            =   4320
      TabIndex        =   6
      TabStop         =   0   'False
      Top             =   900
      Width           =   255
   End
   Begin VB.OptionButton optValue 
      Height          =   255
      Index           =   0
      Left            =   4320
      TabIndex        =   5
      TabStop         =   0   'False
      Top             =   180
      Width           =   255
   End
   Begin VB.CommandButton cmdCalculate 
      Caption         =   "Calculate!"
      Default         =   -1  'True
      Height          =   375
      Left            =   1823
      TabIndex        =   4
      Top             =   2280
      Width           =   1095
   End
   Begin VB.TextBox txtField 
      BackColor       =   &H00FFFFFF&
      Height          =   285
      Index           =   3
      Left            =   2160
      TabIndex        =   3
      Text            =   "txtSuccess"
      Top             =   1245
      Width           =   1935
   End
   Begin VB.TextBox txtField 
      Height          =   285
      Index           =   2
      Left            =   2160
      TabIndex        =   2
      Text            =   "txtTrivial"
      Top             =   885
      Width           =   1935
   End
   Begin VB.TextBox txtField 
      Height          =   285
      Index           =   1
      Left            =   2160
      TabIndex        =   1
      Text            =   "txtMod"
      Top             =   525
      Width           =   1935
   End
   Begin VB.TextBox txtField 
      Height          =   285
      Index           =   0
      Left            =   2160
      TabIndex        =   0
      Text            =   "txtSkill"
      Top             =   165
      Width           =   1935
   End
   Begin VB.Label lblInfo 
      Alignment       =   2  'Center
      Caption         =   "lblInfo"
      Height          =   375
      Left            =   120
      TabIndex        =   12
      Top             =   1680
      Width           =   4575
   End
   Begin VB.Label lblSuccess 
      Alignment       =   1  'Right Justify
      Caption         =   "Success Rate:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   120
      TabIndex        =   11
      Top             =   1200
      Width           =   1935
   End
   Begin VB.Label lblTrivial 
      Alignment       =   1  'Right Justify
      Caption         =   "Trivial:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   120
      TabIndex        =   10
      Top             =   840
      Width           =   1935
   End
   Begin VB.Label lblMod 
      Alignment       =   1  'Right Justify
      Caption         =   "Modifier:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   120
      TabIndex        =   9
      Top             =   480
      Width           =   1935
   End
   Begin VB.Label lblSkill 
      Alignment       =   1  'Right Justify
      Caption         =   "Skill:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   120
      TabIndex        =   8
      Top             =   120
      Width           =   1935
   End
End
Attribute VB_Name = "SkillCalc"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim CurrIndex As Integer

Private Sub Form_Load()
    lblInfo.Caption = ""
    
    txtField(0).Text = "0"
    txtField(1).Text = "0"
    txtField(2).Text = "0"
    txtField(3).Text = "0"
    
    CurrIndex = 3
    optValue(CurrIndex).Value = True
    txtField(CurrIndex).Enabled = False
    txtField(CurrIndex).BackColor = &H8000000F
    txtField(CurrIndex).TabStop = False
End Sub

Private Sub optValue_Click(Index As Integer)
    txtField(CurrIndex).Enabled = True
    txtField(CurrIndex).BackColor = &H80000005
    txtField(CurrIndex).TabStop = True
    txtField(CurrIndex).FontBold = False
    
    txtField(Index).Enabled = False
    txtField(Index).BackColor = &H8000000F
    'txtField(Index).Text = ""
    txtField(Index).TabStop = False
    txtField(Index).FontBold = True

    CurrIndex = Index
End Sub

Private Sub txtField_GotFocus(Index As Integer)

    txtField(Index).SelStart = 0
    txtField(Index).SelLength = Len(txtField(Index).Text)

    If Index = 0 Then
        lblInfo.Caption = "Your base skill level."
    ElseIf Index = 1 Then
        lblInfo.Caption = "Skill modifier percentage as an integer between 1 and 15."
    ElseIf Index = 2 Then
        lblInfo.Caption = "Trivial skill level of the item."
    ElseIf Index = 3 Then
        lblInfo.Caption = "Success rate as an integer between 5 and 95."
    End If

End Sub

Private Sub cmdCalculate_Click()
    Dim Skill As Integer
    Dim Modifier As Long
    Dim Trivial As Integer
    Dim Success As Integer

    If txtField(0).Text <> "" Then
        Skill = txtField(0).Text
    Else
        Skill = 0
    End If
    
    If txtField(1).Text <> "" Then
        Modifier = 1 + (txtField(1).Text / 100)
    Else
        Modifier = 1#
    End If
    
    If txtField(2).Text <> "" Then
        Trivial = txtField(2).Text
    Else
        Trivial = 0
    End If
    
    If txtField(3).Text <> "" Then
        Success = txtField(3).Text
    End If

    If CurrIndex = 0 Then
        txtField(0).Text = CalculateSkill(Trivial, Modifier, Success)
    ElseIf CurrIndex = 2 Then
        txtField(2).Text = CalculateTrivial(Skill, Modifier, Success)
    ElseIf CurrIndex = 3 Then
        txtField(3).Text = CalculateSuccess(Trivial, Skill, Modifier)
    End If
End Sub

Private Function CalculateSkill(Trivial As Integer, Modifier As Long, Success As Integer)
    Dim Skill As Integer

    If Success < 5 Then
        Success = 5
    End If

    If Success > 95 Then
        Success = 95
    End If

    If Trivial >= 68 Then
        Skill = (Success + 0.75 * Trivial - 52#) / Modifier
    Else
        Skill = (Success + Trivial - 66.5) / Modifier
    End If

    CalculateSkill = Skill
End Function

Private Function CalculateSuccess(Trivial As Integer, Skill As Integer, Modifier As Long)
    Dim Success As Integer
    Dim Effskill As Long
    
    Effskill = Skill * Modifier

    If Effskill > 252# Then
        Effskill = 252#
    End If

    If Trivial >= 68 Then
        Success = Effskill - 0.75 * Trivial + 52#
    Else
        Success = Effskill - Trivial + 66.5
    End If

    If Success < 5 Then
        Success = 5
    End If

    If Success > 95 Then
        Success = 95
    End If

    CalculateSuccess = Success
End Function

Private Function CalculateTrivial(Skill As Integer, Modifier As Long, Success As Integer)
    Dim Trivial As Integer
    Dim Effskill As Long
    
    Effskill = Skill * Modifier

    If Effskill > 252# Then
        Effskill = 252#
    End If
    
    Trivial = (4# / 3# * (Effskill - Success + 51.5))

    If Trivial < 68 Then
        Trivial = Effskill - Success + 66#
    End If
    
    CalculateTrivial = Trivial
End Function
