#include <stdio.h>
#include <stdlib.h>

void EntryForTrivial(void);
void EntryForSuccess(void);

int PromptForTrivial(void);
int PromptForSkill(void);
float PromptForMod(void);
int PromptForSuccess(void);

int CalculateTrivial(int, float, int);
int CalculateSuccess(int, int, float);

int main(void)
{
	int input = 0;

	while(input != 3)
	{
		printf("What are you wanting to calculate:\n\n");
		printf("1) Trivial from Skill, Mod, and Success Rate,\n");
		printf("2) Success Rate from Trivial, Skill, and Mod.\n");
		printf("3) Exit Program\n\n");
		printf("Choose -->");

		scanf("%d", &input);

		switch(input)
		{
			case 1:EntryForTrivial();
			       break;
			case 2:EntryForSuccess();
			       break;
		}
	}

	return 0;
}

void EntryForTrivial(void)
{
	int skill, success;
	float mod;

	printf("\n\n");
	skill = PromptForSkill();
	mod = PromptForMod();
	success = PromptForSuccess();

	printf("\n\n");
	printf("The approximate trivial based on the values entered is -->");
	printf("%d\n\n", CalculateTrivial(skill, mod, success));

	return;
}

	
void EntryForSuccess(void)
{
	int trivial, skill;
	float mod;

	printf("\n\n");
	trivial = PromptForTrivial();
	skill = PromptForSkill();
	mod = PromptForMod();

	printf("\n\n");
	printf("The approximate success rate based on the values entered is ");
	printf("-->");
	printf("%d%%\n\n", CalculateSuccess(trivial, skill, mod));

	return;
}


int PromptForTrivial(void)
{
	int trivial= -1;

	while(trivial < 0 || trivial > 500)
	{
		printf("What is the trivial of the item? -->");
		scanf("%d", &trivial);
	}
	return trivial;
}


int PromptForSkill(void)
{
	int skill = -1;

	while(skill < 0 || skill > 250)
	{
		printf("What is your current skill? -->");
		scanf("%d", &skill);
	}

	return skill;
}


float PromptForMod(void)
{
	float mod;
	int input = -1;

	while(input < 0 || input > 15)
	{
		printf("What percent modifier do you have?");
		printf("(Enter 0 if none) -->");
		scanf("%d", &input);
	}

	mod = 1 + (float)input / 100;

	return mod;
}


int PromptForSuccess(void)
{
	int success = -1;

	while(success < 5 || success > 95)
	{
		printf("What success rate in percent are you getting? -->");
		scanf("%d", &success);
	}

	return success;
}


int CalculateTrivial(int skill, float mod, int success)
{
	float effskill;
	int trivial;

	effskill = (float)skill * mod;

	if (effskill > 252.0)
		effskill = 252.0;

	trivial = (int)(4.0/3.0*(effskill - (float)success + 51.5));

	if(trivial < 68)
		trivial = effskill - (float)success + 66.0;
	
	return trivial;
}

	
int CalculateSuccess(int trivial, int skill, float mod)
{
	float effskill;
	int success;

	effskill = (float)skill * mod;

	if (effskill > 252.0)
		effskill = 252.0;

	if (trivial >= 68)
		success = (int)(effskill-.75*(float)trivial+52.0);
	else
		success = (int)(effskill-(float)trivial+66.5);

	if (success < 5)
		success = 5;

	if (success > 95)
		success = 95;

	return success;
}

	
